#!/bin/bash


if [ "$1" == "--schedule" ]; then
    echo "bash $0 > /dev/null 2>&1" | at now + 70 minute
    echo "Task scheduled to run in 1 minute via 'at'"
    exit 0
fi

NUM_PROCESS=2
DEVICE_IDS="[0, 3, 4, 5]"


SCRIPT_PATH="evaluate_memory_vs_reasoning_mp.py"
MODEL_PATH="/Agent_ScanKit/models/GUI-Owl-32B"
MODEL_NAME="GUI-Owl-32B"
DATASET_NAME="AndroidControl"
PROBING_METHOD="raw"
DATASET_TYPE="low"
DATASET_PATH="/Agent_ScanKit/datasets/json/${DATASET_NAME}/${DATASET_TYPE}_test_gui_owl.json"
RESULT_PATH="/Agent_ScanKit/results/${DATASET_NAME}/${DATASET_NAME}_${DATASET_TYPE}_${MODEL_NAME}_raw.json"
LOG_DIR="/Agent_ScanKit/logs/evaluation"
THOUGHT="false"

PID=$$
mkdir -p "$LOG_DIR"
LOG_PATH="$LOG_DIR/${DATASET_NAME}/${DATASET_NAME}_${DATASET_TYPE}_${MODEL_NAME}_raw.log"

echo "Process started with PID: $PID" > "$LOG_PATH"

nohup python "$SCRIPT_PATH" \
    --model_path "$MODEL_PATH" \
    --model_name "$MODEL_NAME" \
    --dataset_name "$DATASET_NAME" \
    --dataset_type "$DATASET_TYPE" \
    --dataset_path "$DATASET_PATH" \
    --result_path "$RESULT_PATH" \
    --num_process "$NUM_PROCESS" \
    --deviceIds "$DEVICE_IDS" \
    --thought "$THOUGHT" \
    --probing_method "$PROBING_METHOD" \
    > "$LOG_PATH" 2>&1 &

echo "Task started. Logs saved to: $LOG_PATH"
